﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NovelInterpreter.Interpreter.Enum;
using System.Collections;

using UnityEngine;

namespace NovelInterpreter.Interpreter.Construction
{
	/// <summary>
	/// 文章の表示とか
	/// </summary>
	public class Word : BaseConstruction
	{
		public Word(int lineNumber, Dictionary<string, string> arguments)
			: base(lineNumber, "Word", arguments)
		{
			//Console.WriteLine("Word\n");
		}

		public override InvokeResult Invoke(ConstructionContainer.Accessor accessor)
		{
			//Console.WriteLine(this.args["Text"]);

			// いちいちFindするの重い！
			GameObject inst = GameObject.Instantiate(GameObject.Find("PrefabManager").GetComponent<PrefabManager>().msgWindowPref) as GameObject;
			var script = inst.GetComponent<MessageWindow>();

            // +=するのは文字を追加するから
            script.drawText += this.args["Text"];

			return new InvokeResult(InvokeResult.ResultType.Next);
		}

	}
}
